<?php

namespace Suiterus\Adg\Reports;

use App\Models\User;
use Faker\Factory;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Suiterus\Adg\Models\Reports\Reports;
use Suiterus\Adg\Services\ReportService;
use App\Enums\ReportType;
use App\Enums\ContributoryTypes;
use Suiterus\Adg\Factories\Contribution\ContributionCalculatorFactory;


class PhilhealthReport extends FileReport
{
    use EmployeeTrait;
    use EmployerTrait;

    public function generate($reportId)
    {
        $users = User::whereNotIn('id', [1, 2])->with('employeeExtraField', 'salary.publicSalary.salaryGrade', 'salary.privateSalary', 'serviceRecord.remark')->without('salary.user')->get();
        $report = Reports::where('id', $reportId)->with('creator')->first();
        $dateOfReport = Carbon::now()->toDateString();
        $reportService = new ReportService;
        $path = $reportService->getFileTemplate(ReportType::PHILHEALTH);
        $this->initializeEmployerInfo($report->creator);
        $employerId = $this->employers_id .' ';
        $employerName = $this->employers_name;
        $address = ' ';
        $contribution = ContributionCalculatorFactory::create(ContributoryTypes::PHILHEALTH);
        
        
        foreach ($users as $key => $user) {
            $this->initializeEmployeeInfo($user);
            $philhealthId[] = $user->employeeExtraField->pluck('employeeExtraFieldColumn')->flatten()->where('field_name', 'philhealth_id')->pluck('field_value')->first();
            $index[] = $key + 1;
            $lastName[] = $this->last_name;
            $firstName[] = $this->first_name;
            $nameExtension[] = $this->suffix;
            $middleName[] = $this->middle_name;
            $birthDate[] =  $this->date_of_birth;
            $sex[] = $this->gender;
            $basicSalary[] = $this->basic_salary;
            $contributionSalary = $contribution->compute($user->id, $this->basic_salary, $report->start_date);
            $personalShare[] = $contributionSalary['personal_share'];
            $governmentShare[] = $contributionSalary['government_share'];
            $remarksId[] = '';
        }
        
        return $this->exportToCSV([
                '{employer_id}' => $employerId,
                '{employer_name}' => $employerName,
                '{address}' => $address,
                '[philhealth_id]' => $philhealthId,
                '[index]' => $index,
                '[last_name]' => $lastName,
                '[first_name]' => $firstName,
                '[extension_name]' => $nameExtension,
                '[middle_name]' => $middleName,
                '[birth_date]' => $birthDate,
                '[sex]' => $sex,
                '[basic_salary]' => $basicSalary,
                '[ee_share]' => $personalShare,
                '[er_share]' => $governmentShare,
                '[remarks]' => $remarksId,
            ],  $dateOfReport . 'Philhealth-report-' . $reportId . '.xlsx', $path);
    }
}
