<?php

namespace Suiterus\Adg\Reports;

use alhimik1986\PhpExcelTemplator\params\ExcelParam;
use alhimik1986\PhpExcelTemplator\setters\CellSetterArrayValueSpecial;
use App\Enums\Payroll\PayrollType;
use App\Enums\Status;
use App\Models\User;
use Carbon\Carbon;
use Maatwebsite\Excel\Facades\Excel;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Controllers\Payroll\Generator\PayrollGenerator;
use Suiterus\Adg\Exports\Payroll\PayrollJournalExport;
use Suiterus\Adg\Models\Payroll\Allowance;
use Suiterus\Adg\Models\Payroll\Payroll;
use Suiterus\Adg\Models\Payroll\PayrollEmployee;
use Suiterus\Adg\Models\Payroll\SpecialPay;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Suiterus\Adg\Models\SM\Loan;

class PayrollJournalReport extends FileReport
{
    use EmployerTrait;
    use EmployeeTrait;

    public function generate($payroll_id)
    {
        $payroll = Payroll::whereId($payroll_id)->with('payroll_employee')->first();
        $this->initializeEmployerInfo($payroll->user);
        $employer_name = $this->employers_name;
        $payroll_period = $this->getPayrollPeriod($payroll->period_start, $payroll->period_end);
        $data = [];

        foreach ($payroll->payroll_employee as $key => $payroll_employee) {
            $employee_payroll = PayrollEmployee::whereId($payroll_employee->id)->with('user')->first();
            $user = $employee_payroll->user;
            $generator = new PayrollGenerator();
            $this->initializeEmployeeInfo($user);

            $lwop = $generator->fetch_lwop_details($employee_payroll, $user);
            $deductions = $generator->fetch_deductions($employee_payroll);
            $earnings = $generator->fetch_allowances($employee_payroll);

            $arr1 = [
                "No." => $key+1,
                "Employee name\nPosition title\nStatus\nETD" => $this->getFullName() ."\n". $user->employeeMetaInfo->position->title ."\n". $user->employeeMetaInfo->employeeType->title ."\n". $user->employeeMetaInfo->date_hired,
                "Employee no." => $this->employee_id,
                "Rate\nLong pay/mo" => number_format($this->basic_salary, 2),
                "Basic Pay" => $employee_payroll->basic_pay,
                "Gross pay" => $employee_payroll->gross_pay,
                "Net pay" =>$employee_payroll->net_pay,     
            ];

            $data[] = array_merge($arr1, $this->filterEarnings($earnings), $this->filterDeductions($deductions), $this->getLoans($deductions['loans']));
        }
        $data[] = ['employer_name' => 'NATIONAL KIDNEY TRANSPLANT INSTITUTE', 'date' => $payroll_period];
        return (new PayrollJournalExport($data))->download('journal.xlsx');

    }

    private function getPayrollPeriod($stard_date, $end_date) {
        $start_month = date('M', strtotime($stard_date));
        $end_month = date('M', strtotime($end_date));
        $start_day = date('j', strtotime($stard_date));
        $end_day = date('j', strtotime($end_date));
        $year = date('Y', strtotime($end_date));
        if ($start_month !== $end_month) {
            // If the start and end months are different, display both months
            return $start_month . ' ' . $start_day . ' - ' . $end_month . ' ' . $end_day . ', ' . $year;
        } else {
            // If the start and end months are the same, display only one month
            return$start_month . ' ' . $start_day . ' - ' . $end_day . ', ' . $year;
        }
    }

    private function filterEarnings($earnings) {

        $data = $this->setEarnings($earnings);

        if (isset($data['Basic Pay'])) {
            unset($data['Basic Pay']);
        }
        return $this->chunkAndConcat($data); 
    }
    private function setEarnings($earnings) {
        foreach ($earnings as $earn) {
            if(isset($earn['title'])) {
                $allowances[] = [
                    $earn['title'] => $earn['amount']
                ];
            }  
        }
        return call_user_func_array('array_merge', $allowances);
    }
    private function getLoans($user_loans) {
        $active_loans = Loan::where('status', Status::ACTIVE)->get();
        $data = [];
        $user_loans = collect($user_loans);
        foreach ($active_loans as $loan) {
            $result = $user_loans->where('name', $loan->name)->first();
            if ($result) {
                $data[$loan['name']] = $result->amount;
            } else {
                $data[$loan['name']] = number_format(0,2);
            }
        }
        return $this->chunkAndConcat($data);
    }

    private function filterDeductions($deductions) {
        if (isset($deductions['loans'])) {
            unset($deductions['loans']);
        }

        $transformedArray = array_combine(
            array_map(function($key) {
                return ucfirst(str_replace('_', ' ', $key));
            }, array_keys($deductions)),
            $deductions
        );

        return $this->chunkAndConcat($transformedArray);    
    }

    private function chunkAndConcat($array) {
        $data = [];
        $chunks = array_chunk($array, 4, true);
        foreach ($chunks as $chunk) {
            $title = implode("\n", array_keys($chunk));
            $amount = implode("\n", array_values($chunk));
            $data[$title] = $amount;
        }
        return $data;
    }
}
