<?php

namespace Suiterus\Adg\Reports;

use App\Models\User;
use App\Enums\ReportType;
use Illuminate\Support\Carbon;
use App\Enums\ContributoryTypes;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use Suiterus\Adg\Models\Reports\Reports;
use Suiterus\Adg\Services\ReportService;
use Suiterus\Adg\Factories\Contribution\ContributionCalculatorFactory;


class PagibigReport extends FileReport
{
    use EmployeeTrait;
    use EmployerTrait;

    public function generate($reportId)
    {
        $all_employees = User::whereNotIn('id', [1, 2])->with('employeeExtraField', 'serviceRecord', 'salary.publicSalary.salaryGrade', 'salary.privateSalary')->without('salary.user')->get();
        $report = Reports::whereId($reportId)->with('creator')->first();
        $pagibigShare = ContributionCalculatorFactory::create(ContributoryTypes::PAGIBIG);
        
        $this->initializeEmployerInfo($report->creator);
        $employer_name = $this->employers_name;
        $employer_id = $this->employers_id;
    
        foreach ($all_employees as $key=>$user) {
            $this->initializeEmployeeInfo($user);
            $indexes[] = $key + 1;
            $pagibig_no[] = $user->employeeExtraField->pluck('employeeExtraFieldColumn')->flatten()->where('field_name', 'pagibig_no')->pluck('field_value')->first();
            $account_no[] = isset($user->salary) ? $user->salary->pluck('account_number')->first() : "";
            $mandatory_contri_code[] = "Pag-IBIG 1 (F1)";
            $last_name[] = $this->last_name;
            $first_name[] = $this->first_name;
            $name_extension[] = $this->suffix;
            $middle_name[] = $this->middle_name;
            $period_coverage[] = Carbon::createFromFormat('Y-m-d', $report->end_date);
            $pagibigShareCalculate = $pagibigShare->compute($user->id, $this->basic_salary, $report->start_date);
            $ee_share[] = $pagibigShareCalculate['personal_share'];
            $er_share[] = $pagibigShareCalculate['government_share'];
            $remarks[] = '';
            // $user->serviceRecord->pluck('remark_id')->first(); //commented because this is out of scope, and it should get the remark name not the id
        }
        return $this->exportToCSV([
            '{employer_id}' => $employer_id,
            '{employer_name}' => $employer_name,
            '{address}' => 'Quezon City, Philippines',
            '[number]' => $indexes,
            '[pagibig_id_rtn]' => $pagibig_no,
            '[account_number]' => $account_no,
            '[f1_pagibig_1]' => $mandatory_contri_code,
            '[last_name]' => $last_name,
            '[first_name]' => $first_name,
            '[name_extension]' => $name_extension,
            '[middle_name]' => $middle_name,
            '[percov]' => $period_coverage,
            '[ee_share]' => $ee_share,
            '[er_share]' => $er_share,
            '[remarks]' => $remarks,
        ], Carbon::now()->format('Y-m-d') . '-' . 'Pag-IBIG' . '-' . 'Contribution' . '-' . 'Report' . '-' . $reportId . '.xlsx', (new ReportService)->getFileTemplate(ReportType::PAGIBIG));
    }
}
