<?php

namespace Suiterus\Adg\Reports;

use App\Models\User;
use App\Enums\ReportType;
use Illuminate\Support\Carbon;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use Suiterus\Adg\Models\Reports\Reports;
use Suiterus\Adg\Services\ReportService;


class PagibigLoanReport extends FileReport
{
    use EmployeeTrait;
    use EmployerTrait;

    public function generate()
    {
        $all_employees = User::whereNotIn('id', [1, 2])->has('loan')->with('employeeExtraField', 'serviceRecord', 'salary.publicSalary.salaryGrade', 'salary.privateSalary')->without('salary.user')->get();
        $report = Reports::whereId(2)->with('creator')->first();

        $this->initializeEmployerInfo($report->creator);
        $employer_name = $this->employers_name;
        $employer_id = $this->employers_id;

        foreach ($all_employees as $key => $user) {
            $this->initializeEmployeeInfo($user);
            $pagibig_no[] = $user->employeeExtraField->pluck('employeeExtraFieldColumn')->flatten()->where('field_name', 'pagibig_no')->pluck('field_value')->first();
            $app_agree_number = $this->getApplicationAgreementNumber($user->loan->pluck('purpose_of_loan')->first());
            if(array_key_exists('AGREEMENT_NUMBER', $app_agree_number)) {
                $aa_no[] = $app_agree_number['AGREEMENT_NUMBER'];
            } else {
                $aa_no[] = " ";
            }
            $last_name[] = $this->last_name;
            $first_name[] = $this->first_name;
            $name_extension[] = $this->suffix;
            $middle_name[] = $this->middle_name;
            $loan_type[] = "MP3 - Regular MPL";
            $amount[] = $user->loan->pluck('amount')->first();
            $remarks[] = " ";
        }
        return $this->exportToCSV([
            '{employer_id}' => $employer_id,
            '{employer_name}' => $employer_name,
            '{address}' => 'Quezon City, Philippines',
            '[pagibig_id_rtn]' => $pagibig_no,
            '[application_agreement_no]' => $aa_no,
            '[last_name]' => $last_name,
            '[first_name]' => $first_name,
            '[name_extension]' => $name_extension,
            '[middle_name]' => $middle_name,
            '[loan_type]' => $loan_type,
            '[amount]' => $amount,
            '[remarks]' => $remarks,
        ], Carbon::now()->format('Y-m-d') . '-' . 'Pag-IBIG' . '-' . 'Loan' . '-' . 'Report' . '-' . 2 . '.xlsx', (new ReportService)->getFileTemplate(ReportType::PAGIBIG_LOAN));
    }

    public function getApplicationAgreementNumber(?String $purpose_of_loan)
    {
        if (!$purpose_of_loan) {
            return [];
        }
        $application_agreement_no = [];
        $pattern = "/AGREEMENT_NUMBER: ?[0-9, a-z, A-Z][^, ]*|APP_NUMBER: ?[0-9, a-z, A-Z][^, ]*/";
        preg_match_all($pattern, $purpose_of_loan, $matches);
        foreach ($matches as $match) {
            foreach ($match as $app_agreement_number) {
                $splitted_agreement_no = explode(':', $app_agreement_number);
                $application_agreement_no[$splitted_agreement_no[0]] = $splitted_agreement_no[1];
            }
        }
        return $application_agreement_no;
    }
}
