<?php

namespace Suiterus\Adg\Reports;

use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Border;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class NewHireTurnoverRateReport implements FromArray, WithHeadings, ShouldAutoSize, WithStyles, WithColumnWidths, WithEvents
{
    use Exportable;

    protected $data;

    public function __construct($data)
    {
       $this->data = $data;
    }

    public function array(): array
    {
        if (empty($this->data)) {
            return [];
        }

        return $this->data;
    }

    public function headings(): array
    {
        return [
            'No.',
            'Department',
            'Division',
            'No. of New Hires Left the Company during the First Quarter the Year',
            'Total No. of New Hires During that Period',
            'New Hire Turnover Rate'
        ];
    }

    public function styles(Worksheet $sheet)
    {   
        $styleArray = array(
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'wrapText' => true
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ],
            ],
        );

        $headerStyle = [
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'wrapText' => true
            ],
            'font' => [
                'bold' => true,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ],
            ],
        ];

        $sheet->getStyle('A1:F1')->applyFromArray($headerStyle);
        $lastRow = count($this->data) + 1;
        $sheet->getStyle('A2:F' . $lastRow)->applyFromArray($styleArray);
    }

    public function columnWidths(): array
    {
        return [
            'A' => 20,
            'B' => 30,
            'C' => 30,
            'D' => 40,
            'E' => 40,
            'F' => 20
        ];
    }
    
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet;
                $lastRow = count($this->data) + 1;

                $totalActiveUsers = array_sum(array_column($this->data, 'active_users'));
                $totalInactiveUsers = array_sum(array_column($this->data, 'inactive_users'));
                $totalRate = ($totalActiveUsers == 0) ? '0' : number_format(($totalInactiveUsers / $totalActiveUsers) * 100, 2) . '%';

                $sheet->setCellValue('D' . ($lastRow + 1), $totalInactiveUsers);
                $sheet->setCellValue('E' . ($lastRow + 1), $totalActiveUsers);
                $sheet->setCellValue('F' . ($lastRow + 1), $totalRate);

                $styleArray = [
                    'font' => ['bold' => true],
                    'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER],
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ],
                    ],
                ];
    
                $sheet->getStyle('D' . ($lastRow + 1) . ':F' . ($lastRow + 1))->applyFromArray($styleArray);
            },
        ];
    }
}