<?php

namespace Suiterus\Adg\Reports;

use Carbon\Carbon;
use App\Models\User;
use App\Enums\ReportType;
use App\Enums\Log\ReportLogType;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use Suiterus\Adg\Models\Reports\Reports;
use Suiterus\Adg\Services\ReportService;
use Suiterus\Hrjp\Models\Applicant_account as AC;
use Illuminate\Database\Eloquent\ModelNotFoundException as ME;

class HiredEmployeeReport extends FileReport
{
    use EmployeeTrait;
    use EmployerTrait;

    public function generate($reportId)
    {

        $total_number = 0;
        $hired = 4;

        $report = Reports::whereId($reportId)->with('creator')->first();
        $report_service = new ReportService;

        $date = $report->end_date;

        $hired_employees = User::whereHas('employeeMetaInfo', function ($query) use($date) {
            $newly_hired_date = Carbon::parse($date)->subDays(60)->format('Y-m-d');
            $query->whereBetween('date_hired', [$newly_hired_date, $date]);
        })->where('status', 1)->get();

        $path = $report_service->getFileTemplate($report->report_type);
        $this->initializeEmployerInfo($report->creator);
        $employer_name = $this->employers_name;

        $indexes = [];
        $employees_fullname = [];
        $job_titles = [];
        $dates_hired = [];
        $descriptions = [];
        $total_numbers = 0;

        foreach ($hired_employees as $key => $hired_employee) {
            $this->initializeEmployeeInfo($hired_employee);
            $indexes[] = $key + 1;
            $employees_fullname[] = strtoupper($this->getFullName());
            $job_titles[] = $hired_employee->employeeMetaInfo->position->title;
            $dates_hired[] = $hired_employee->employeeMetaInfo->date_hired;
            $descriptions[] = $hired_employee->employeeMetaInfo->itemCode->description ?? null;
        }

        $total_numbers = $hired_employees->count() ?? 0;

        // Calling the 'exportToCSV' method and passing an associative array of data using 1D array
        // that will be used to populate placeholders in the CSV file per Column.
        return $this->exportToCSV([
            '{name_of_agency}' => $employer_name,
            '{month}' => strtoupper(Carbon::parse($report->end_date)->format('F')),
            '{year}' => strtoupper(Carbon::parse($report->end_date)->format('Y')),
            '[number]' => $indexes,
            '[employee_fullname]' => $employees_fullname,
            '[job_title]' => $job_titles,
            '[date_hired]' => $dates_hired,
            '[description]' => $descriptions,
            '{total_number}' => $total_numbers,
        ],  Carbon::now()->format('F-Y') . '-Hired-Employee-Report-' . $report->id . '.xlsx', $path);

    }
}
