<?php

namespace Suiterus\Adg\Reports;

use App\Models\User;
use Faker\Factory;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use Suiterus\Adg\Services\ReportService;
use Suiterus\Adg\Models\Reports\Reports;
use Carbon\Carbon;
use App\Enums\ReportType;
use App\Enums\UserHasLoansStatus;
use Suiterus\Adg\Factories\Contribution\ContributionCalculatorFactory;
use App\Enums\ContributoryTypes;

class GsisReport extends FileReport
{
    use EmployeeTrait;
    use EmployerTrait;
    public function generate($reportId)
    {   
        $all_employees = User::whereNotIn('id', [1, 2])->with('loan', 'employeeExtraField', 'salary.publicSalary.salaryGrade', 'salary.privateSalary')->without('salary.user')->get();
        $report = Reports::where('id', $reportId)->with('creator')->first();

        $carbonDate = Carbon::createFromFormat('Y-m-d', $report->end_date);
        $due_month = $carbonDate->format('m-Y');
        $dateOfReport = Carbon::now()->toDateString();

        $this->initializeEmployerInfo($report->creator);
        $employer_id = $this->employers_id;
        $remitting_agency = $this->employers_name;
        $office_code =  $this->office_code;
        
        //create calculator
        $calculator = ContributionCalculatorFactory::create(ContributoryTypes::GSIS);

        //get path for GSIS report
        $service = new ReportService();
        $templatePath = $service->getFileTemplate(ReportType::GSIS);
        foreach ($all_employees as $key => $employee) 
        {
            $this->initializeEmployeeInfo($employee);
            $last_name[] = strtoupper($this->last_name);
            $first_name[] = strtoupper($this->first_name);
            $middle_initial[] = strtoupper(mb_substr($this->middle_name, 0, 1));
            $suffix[] = strtoupper($this->suffix);
            $date_of_birth[] = $this->date_of_birth;
            $crn[] = $this->get_user_crn_no($employee);
            $basic_salary[] = $this->basic_salary;
            $gsis_no[] = $this->get_user_gsis_no($employee);
            //Compute contribution using implemented calculator class
            $gsisContribution = $calculator->compute($employee->id, $this->basic_salary, $report->start_date);
            $date_of_effectivity[] = $this->get_date_effectivity($employee);
            $personal_share[] = $gsisContribution['personal_share'];
            $government_share[] = $gsisContribution['government_share'];
            $employee_contribution[] = $gsisContribution['employee_contribution'];
            //LOANS
            $loans = $this->get_gsis_loans($employee, $report->start_date, $report->end_date);
            $consoloan[] = $loans->where('name', 'Consolidation Loan')->first() ? $loans->where('name', 'Consolidation Loan')->first()->get('amount') : 'N/A';
            $e_card_plus[] = $loans->where('name', 'ECARDPLUS')->first() ? $loans->where('name', 'ECARDPLUS')->first()->get('amount') : 'N/A';
            $salary_loan[] = $loans->where('name', 'Salary Loan')->first() ? $loans->where('name', 'Salary Loan')->first()->get('amount') : 'N/A';
            $cash_advance[] = $loans->where('name', 'Cash Advance')->first() ? $loans->where('name', 'Cash Advance')->first()->get('amount') : 'N/A';
            $emergency_loan[] = $loans->where('name', 'Emergency Loan')->first() ? $loans->where('name', 'Emergency Loan')->first()->get('amount') : 'N/A';
            $educ_asst_loan[] = $loans->where('name', 'Educational Assistance Loan')->first() ? $loans->where('name', 'Educational Assistance Loan')->first()->get('amount') : 'N/A';
            $emrgy_loan_asst[] = $loans->where('name', 'Emergency Loan Assistance')->first() ? $loans->where('name', 'Emergency Loan Assistance')->first()->get('amount') : 'N/A';
            $sos[] = $loans->where('name', 'Summer One-Month Loan')->first() ? $loans->where('name', 'Summer One-Month Loan')->first()->get('amount') : 'N/A';
            $plreg[] = $loans->where('name', 'PLREG')->first() ? $loans->where('name', 'PLREG')->first()->get('amount') : 'N/A';
            $plopt[] = $loans->where('name', 'PLOPT')->first() ? $loans->where('name', 'PLOPT')->first()->get('amount') : 'N/A';
            $rel[] = $loans->where('name', 'REL')->first() ? $loans->where('name', 'REL')->first()->get('amount') : 'N/A';
            $lch_dcs[] = $loans->where('name', 'LCH_DCS')->first() ? $loans->where('name', 'LCH_DCS')->first()->get('amount') : 'N/A';
            $stock_purchase_loan[] = $loans->where('name', 'Stock Purchase Loan')->first() ? $loans->where('name', 'Stock Purchase Loan')->first()->get('amount') : 'N/A';
            $opt_life[] = $loans->where('name', 'OPT_LIFE')->first() ? $loans->where('name', 'OPT_LIFE')->first()->get('amount') : 'N/A';
            $ceap[] = $loans->where('name', 'CEAP')->first() ? $loans->where('name', 'CEAP')->first()->get('amount') : 'N/A';
            $edu_child[] = $loans->where('name', 'EDU_CHILD')->first() ? $loans->where('name', 'EDU_CHILD')->first()->get('amount') : 'N/A';
            $genesis[] = $loans->where('name', 'GENESIS')->first() ? $loans->where('name', 'GENESIS')->first()->get('amount') : 'N/A';
            $genplus[] = $loans->where('name', 'GENPLUS')->first() ? $loans->where('name', 'GENPLUS')->first()->get('amount') : 'N/A';
            $genflexi[] = $loans->where('name', 'GENFLEXI')->first() ? $loans->where('name', 'GENFLEXI')->first()->get('amount') : 'N/A';
            $genspcl[] = $loans->where('name', 'GENSPCL')->first() ? $loans->where('name', 'GENSPCL')->first()->get('amount') : 'N/A';
            $help[] = $loans->where('name', 'HELP')->first() ? $loans->where('name', 'HELP')->first()->get('amount') : 'N/A';
            $gfal[] = $loans->where('name', 'GFAL')->first() ? $loans->where('name', 'GFAL')->first()->get('amount') : 'N/A';
            $mpl[] = $loans->where('name', 'MPL')->first() ? $loans->where('name', 'MPL')->first()->get('amount') : 'N/A';
            $cpl[] = $loans->where('name', 'CPL')->first() ? $loans->where('name', 'CPL')->first()->get('amount') : 'N/A';
            $gel[] = $loans->where('name', 'GEL')->first() ? $loans->where('name', 'GEL')->first()->get('amount') : 'N/A';

        }
        return $this->exportToCSV([
            '{remitting_agency}' => $remitting_agency,
            '{office_code}' => $office_code,
            '{due_month}' => $due_month,
            '[bpno]' => $gsis_no,
            '[last_name]' => $last_name,
            '[first_name]' => $first_name,
            '[middle_initial]' => $middle_initial,
            '[appellation]' => $suffix,
            '[birth_date]' => $date_of_birth,
            '[crn]' => $crn,
            '[basic_monthly_salary]' => $basic_salary,
            '[effectivity_date]' => $date_of_effectivity,
            '[ps]' => $personal_share,
            '[gs]' => $government_share,
            '[ec]' => $employee_contribution,
            '[consoloan]' => $consoloan,
            '[e_card_plus]' => $e_card_plus,
            '[consoloan]' => $consoloan,
            '[salary_loan]' => $salary_loan,
            '[cash_advance]' => $cash_advance,
            '[emergency_loan]' => $emergency_loan,
            '[educ_asst_loan]' => $educ_asst_loan,
            '[emrgy_loan_asst]' => $emrgy_loan_asst,
            '[sos]' => $sos,
            '[plreg]' => $plreg,
            '[plopt]' => $plopt,
            '[rel]' => $rel,
            '[lch_dcs]' => $lch_dcs,
            '[stock_purchase_loan]' => $stock_purchase_loan,
            '[opt_life]' => $opt_life,
            '[ceap]' => $ceap,
            '[edu_child]' => $edu_child,
            '[genesis]' => $genesis,
            '[genplus]' => $genplus,
            '[genflexi]' => $genflexi,
            '[genspcl]' => $genspcl,
            '[help]' => $help,
            '[gfal]' => $gfal,
            '[mpl]' => $mpl,
            '[cpl]' => $cpl,
            '[gel]' => $gel

        ], $dateOfReport . 'GSIS-REPORT-' . $reportId . '.xlsx', $templatePath);
    
    
    
    }

    public function get_date_effectivity($user)
    {
        $user_salary = $user->salary()->without('user')->with(['publicSalary'])->first();
        return $user_salary ? $user_salary->date_of_effectivity : "N/A";
    }

    public function get_user_gsis_no($user)
    {
        return $gsis = isset($user->personalInformation->employeeExtraFieldColumn) ? $user->personalInformation->employeeExtraFieldColumn->where('field_name', 'gsis_id')->pluck('field_value')->first() : "N/A";
    }

    public function get_user_crn_no($user)
    {
        $gsis = isset($user->personalInformation->employeeExtraFieldColumn) ? $user->personalInformation->employeeExtraFieldColumn->where('field_name', 'crn_no')->pluck('field_value')->first() : "N/A";
        return $gsis ? $gsis : "N/A";
    }

    //Function to get loans
    public function get_gsis_loans($employee, $start_date, $end_date) {
        $loans = $employee->loan()->with(['loanType' => function($query){
            $query->select('id', 'name', 'status');
        }])
        ->whereDate('to', '>=', $start_date)
        ->whereDate('to', '<=', $end_date)
        ->where('status', UserHasLoansStatus::APPROVED)
        ->without(['user'])
        ->get();
        
        $gsisAllowed = ['Consolidation Loan', 'ECARDPLUS', 'Salary Loan', 'Cash Advance', 'Emergency Loan', 'Educational Assistance Loan', 'Emergency Loan Assistance', 
        'Summer One-Month Loan', 'PLREG', 'PLOPT', 'REL', 'LCH_DCS', 'Stock Purchase Loan', 'OPT_LIFE', 'CEAP', 'EDU_CHILD', 'GENESIS', 'GENPLUS', 'GENFLEXI', 'GENSPCL',
        'HELP', 'GFAL', 'MPL', 'CPL', 'GEL'];

        //Collect loan name and amount and return
        $gsisLoans = collect();
        foreach ($loans as $loan){
            if(in_array($loan->loanType->name, $gsisAllowed)){
                $loanCollect = collect([
                    'name' => $loan->loanType->name,
                    'amount' => $loan->amount
                ]);
                $gsisLoans->push($loanCollect);
            }
        }
        return $gsisLoans;
    }
}
