<?php

namespace Suiterus\Adg\Reports;

use App\Models\User;
use App\Enums\ReportType;
use Illuminate\Support\Carbon;
use Suiterus\Adg\Models\SM\Sector;
use Suiterus\Adg\Abstracts\FileReport;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Traits\EmployeeTrait;
use Suiterus\Adg\Traits\EmployerTrait;
use Suiterus\Adg\Models\Reports\Reports;
use Suiterus\Adg\Services\ReportService;
use Suiterus\Adg\Exceptions\Reports\ReportException;


class DailyRateReport extends FileReport
{
    use EmployeeTrait;
    use EmployerTrait;

    public function generate($reportId)
    {
        $sector = Sector::where('status', 'active')->first();

        $report = Reports::find($reportId);

        $users = User::when($sector->name == 'public', function($query) {
            $query->has('salary.publicSalary.salaryGrade');
        })->when($sector->name == 'private', function($query) {
            $query->has('salary.privateSalary');
        })->whereNotIn('id', [1, 2])->when($report->entity_type == Department::class, function($query) use($report){
            $query->whereHas('employeeMetaInfo.department', function($query) use($report){
                $query->where('id', $report->entity_id);
            });
        })->with('employeeExtraField', 'salary.publicSalary.salaryGrade', 'salary.privateSalary', 'serviceRecord.remark')->without('salary.user')->get();

        $userCount = count($users);

        if ($userCount <= 0) {
            throw new ReportException('No employees found');
        }

        $reportService = new ReportService;
        $this->initializeEmployerInfo(2);
        $employerId = $this->employers_id . ' ';
        $employerName = $this->employers_name;
        $address = ' ';

        $totalDailyRate = 0;
        $totalBasicSalary = 0;

        foreach ($users as $key => $user) {
            $this->initializeEmployeeInfo($user);

            if ($this->getEmployeeMetaInfo()) {
                $department = $this->getEmployeeMetaInfo()->department ? $this->getEmployeeMetaInfo()->department->name : 'N/A';
            }

            $employeeNos[] = ' ' . $this->employee_id . ' ';
            $index[] = $key + 1;
            $lastName[] = $this->last_name;
            $firstName[] = $this->first_name;
            $nameExtension[] = $this->suffix;
            $middleName[] = $this->middle_name;
            $birthDate[] =  $this->date_of_birth;
            $sex[] = $this->gender;
            $departments[] = $department ?? 'N/A';
            $basicSalary[] = $this->basic_salary ?? 0;
            $totalBasicSalary += $this->basic_salary;
            $dailyRate = $this->basic_salary/22;
            $totalDailyRate += $dailyRate;
            $dailyRates[] = number_format($dailyRate, 2);
            $remarksId[] = '';
        }

        $averageBasicSalary = (float) $totalBasicSalary/$userCount;
        $averageDailyRate = (float) $totalDailyRate/$userCount;

        $averageBasicSalary = number_format($averageBasicSalary, 2);
        $averageDailyRate = number_format($averageDailyRate, 2);

        return $this->exportToCSV([
                '{employer_id}' => $employerId,
                '{employer_name}' => $employerName,
                '{address}' => $address,
                '{average_basic_salary}' => $averageBasicSalary,
                '{total_basic_salary}' => number_format($totalBasicSalary, 2),
                '{total_daily_rate}' => number_format($totalDailyRate, 2),
                '{average_daily_rate}' => $averageDailyRate,
                '[employee_no]' => $employeeNos,
                '[index]' => $index,
                '[last_name]' => $lastName,
                '[first_name]' => $firstName,
                '[extension_name]' => $nameExtension,
                '[middle_name]' => $middleName,
                '[birth_date]' => $birthDate,
                '[sex]' => $sex,
                '[departments]' => $departments,
                '[basic_salary]' => $basicSalary,
                '[daily_rate]' => $dailyRates,
                '[remarks]' => $remarksId,
            ],  Carbon::now()->format('Y-m-d') . '-' . 'rate' . '-' . 'per' . '-' . 'day' . '-' . $reportId . '.xlsx', $reportService->getFileTemplate(ReportType::DAILY_RATE));
    }
}
