<?php

namespace Suiterus\Adg\Reports;

use Illuminate\Support\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use Suiterus\Adg\Resources\NewHireTurnoverRateResponse;
use Suiterus\Adg\Services\TalentAcquisition\TalentAcquisitionService;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Suiterus\Adg\Models\Promotion\PromotionApplication;
use Suiterus\Hrjp\Models\Application;

class CostPerHireExcel implements FromCollection, WithHeadings, WithStyles, WithMapping, ShouldAutoSize
{
    private $data;
    public function __construct($data)
    {
        $this->data = $data;

    }

    public function collection()
    {
        return $this->data;
    }


    public function headings(): array
    {
        return [
            'Item Code',
            'Title',
            'Direct Expenses',
            'Indirect Expenses',
            'Cost Per hire'
        ];
    }

    public function map($query): array
    {
        $directExpenses = $query->expenses->where('type', 1)->sum('amount');
        $indirectExpenses = $query->expenses->where('type', 2)->sum('amount');

        $applicationCount = Application::where("phs_id", $query->id)->count();
        $promotionApplicationCount = PromotionApplication::where('phs_id', $query->id)->count();
        $candidates = $applicationCount + $promotionApplicationCount;
        $candidates = $candidates > 0 ? $candidates : 1;
        $costPerHire = ($directExpenses + $indirectExpenses) / $candidates;

        return [
            $query->itemCodes->item_code,
            $query->position->title,
            $directExpenses,
            $indirectExpenses,
            $costPerHire,
        ];

    }

    public function styles(Worksheet $sheet)
    {
        $styleArray = array(
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_LEFT,
                'wrapText' => true
            ],
        );

        $headerStyle = [
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'wrapText' => true
            ],
            'font' => [
                'bold' => true,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ],
            ],
        ];

        $numberStyle = array(
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_RIGHT,
                'wrapText' => true
            ],
        );

        //headers
        $sheet->getStyle([1, 1, 5, 1])->applyFromArray($headerStyle);
        $sheet->getStyle('A')->applyFromArray($styleArray);

        //data
        $sheet->getStyle([2, 2, 5, count($this->data) + 3])->applyFromArray($numberStyle);
        $sheet->getStyle([2, 2, 5, count($this->data) + 3])->getNumberFormat()->setFormatCode('0.00');
    }
}
