<?php

namespace Suiterus\Adg\Reports;

use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Border;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class AbsenteeismReport implements FromArray, WithHeadings, WithStyles, WithMapping, ShouldAutoSize, WithColumnWidths, WithEvents
{   
    private $data;
    private $absenceReport;
    public function __construct($data, $absenceReport)
    {
        $this->data = $data;
        $this->absenceReport = $absenceReport;
    }

    public function array(): array
    {
        return $this->data;
    }


    public function headings(): array
    {
        return [
            'Date',
            'Total Employees',
            'Working Days',
            'Average Working Days',
            'Total Days Lost',
            'Monthly Absent Rate'
        ];
    }

    public function map($query): array
    {
        return [
            $query['date'],
            $query['total_employees'],
            $query['working_days'],
            $query['average_working_days'],
            $query['days_lost'],
            $query['absent_rate'] . '%',
        ];

    }

    public function styles(Worksheet $sheet)
    {
        $styleArray = array(
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_LEFT,
                'wrapText' => true
            ],
        );

        $headerStyle = [
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'wrapText' => true
            ],
            'font' => [
                'bold' => true,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => array('argb' => '00000000'),
                ],
            ],
        ];

        $numberStyle = array(
            'alignment' => [
                'vertical' => Alignment::VERTICAL_CENTER,
                'horizontal' => Alignment::HORIZONTAL_RIGHT,
                'wrapText' => true
            ],
        );

        //headers
        $sheet->getStyle([1, 1, 6, 1])->applyFromArray($headerStyle);
        $sheet->getStyle('A')->applyFromArray($styleArray);

        //data
        $sheet->getStyle([4, 2, 6, count($this->data) + 3])->applyFromArray($numberStyle);
        $sheet->getStyle([4, 2, 6, count($this->data) + 3])->getNumberFormat()->setFormatCode('0.00');
    }

    public function columnWidths(): array
    {
        return [
            'A' => 30,
            'B' => 20,
            'C' => 20,
            'D' => 20,
            'E' => 20,
            'F' => 20
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet;
                $lastRow = count($this->data) + 1;

                $totalEmployees = $this->absenceReport['total_employees'];
                $totalWorkingDays = array_sum(array_column($this->data, 'working_days'));
                $averageWorkingDays = array_sum(array_column($this->data, 'average_working_days'));
                $totalDaysLost = array_sum(array_column($this->data, 'days_lost'));
                $absenceRate = ($totalEmployees > 0 && $averageWorkingDays > 0) ? min(number_format($totalDaysLost / ($totalEmployees * $averageWorkingDays) * 100, 2), 100) : 0;

                $sheet->setCellValue('A' . ($lastRow + 1), 'Total');
                $sheet->setCellValue('B' . ($lastRow + 1), $totalEmployees);
                $sheet->setCellValue('C' . ($lastRow + 1), $totalWorkingDays);
                $sheet->setCellValue('D' . ($lastRow + 1), $averageWorkingDays);
                $sheet->setCellValue('E' . ($lastRow + 1), $totalDaysLost);
                $sheet->setCellValue('F' . ($lastRow + 1), $absenceRate . '%');

                $sheet->getStyle('A' . ($lastRow + 1) . ':F' . ($lastRow + 1))->getFont()->setBold(true);
                $sheet->getStyle('A' . ($lastRow + 1) . ':F' . ($lastRow + 1))->getBorders()->getTop()->setBorderStyle(Border::BORDER_THIN);
            },
        ];
    }
}