<?php

namespace Suiterus\Adg\Models\UserSupervisors;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\UserSupervisors\Supervisors;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserSupervisors extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'supervisor_id',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $with = [
        'supervisor'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.user_supervisors';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function supervisee(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function supervisor(){
        return $this->belongsTo(Supervisors::class, 'supervisor_id', 'id')->with("user.user_supervisor");
    }

    
}
