<?php

namespace Suiterus\Adg\Models\UserSupervisors;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\UserSupervisors\UserSupervisors;

class Supervisors extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.supervisors';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function supervisee(){
        return $this->hasMany(UserSupervisors::class, 'id', 'supervisor_id');
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }



}
