<?php

namespace Suiterus\Adg\Models\Training;
use Suiterus\Adg\Models\SM\TrainingType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Training extends Model
{
    use HasFactory;

    protected $fillable = [
        'training_id',
        'title',
        'subject',
        'date_start',
        'date_end',
        'training_type',
        'type_of_learning_development',
        'service_obligation_year',
        'service_obligation_month',
        'conducted_sponsored_by',
        'message',
        'active',
        'is_manual_input',
        'created_by',
        'updated_by',
    ];
    protected $with = [
        'training_type'
    ];
    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.trainings';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user_training(){
        return $this->hasMany(UserTraining::class, 'training_id', 'training_id');
    }

    public function training_type(){
        return $this->belongsTo(TrainingType::class, 'training_type', 'id');
    }
}
