<?php

namespace Suiterus\Adg\Models\Timekeeping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\ScheduleTemplate;

class Timetable extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'timetables';

    protected $fillable = [
        'name',
        'description',
        'time_in',
        'max_time',
        'time_out',
        'break_in',
        'break_out',
        'minutes',
        'status',
        'shift_type',
        'work_day',  
    ];

    protected $appends = [
        'formatted_time_in',
        'formatted_time_out',
        'formatted_max_time',
        'formatted_break_in',
        'formatted_break_out'
    ];

    public function schedules() {
        return $this->belongsToMany(ScheduleTemplate::class);
    }

    public function getHoursAttribute() {
        return floor($this->minutes / 60) . ':' . ($this->minutes % 60);
    }

    public function getFormattedTimeInAttribute() {
        return date("g:i A", strtotime($this->time_in));
    }

    public function getFormattedTimeOutAttribute() {
        return date("g:i A", strtotime($this->time_out));
    }

    public function getFormattedMaxTimeAttribute() {
        return date("g:i A", strtotime($this->max_time));
    }

    public function getFormattedBreakInAttribute() {
        return date("g:i A", strtotime($this->break_in));
    }

    public function getFormattedBreakOutAttribute() {
        return date("g:i A", strtotime($this->break_out));
    }
}
