<?php

namespace Suiterus\Adg\Models\Timekeeping;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\ScheduleTemplate;

class TemporarySchedule extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'temporary_schedules';

    protected $fillable = [
        'user_id',
        'reason',
        'description',
        'start_date',
        'end_date',
        'date_disabled',
        'status'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.temporary_schedules';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function schedule_template() {
        return $this->morphMany(ScheduleTemplate::class, 'schedulable');
    }

}
