<?php

namespace Suiterus\Adg\Models\Timekeeping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\ScheduleTemplate;

class ScheduleTemplateTimetable extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'schedule_template_timetable';

    protected $fillable = [
        'schedule_template_id',
        'timetable_id'
    ];

    public function schedule_template() {
        return $this->belongsTo(ScheduleTemplate::class, 'schedule_template_id', 'id');
    }

    public function timetable() {
        return $this->belongsTo(Timetable::class, 'timetable_id', 'id');
    }

}
