<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RosterTransferRemarks extends Model
{
    use HasFactory;

    protected $fillable = [
        'old_employee_group_id',
        'new_employee_group_id',
        'remarks',
        'created_by',
        'updated_by'
    ];

    protected $with = [
        'dates'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.roster_transfer_remarks';
        parent::__construct($attributes);
    }

    public function dates()
    {
        return $this->hasMany(RosterTransferDate::class, 'roster_transfer_remarks_id', 'id');
    }
}
