<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RosterTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'template',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'template' => 'json'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.roster_templates';
        parent::__construct($attributes);
    }

    public function createdBy(){
        return $this->belongsTo(User::class, 'created_by', 'id', 'created_by')->without([
            'roles',
            'permissions',
            'supervisor',
            'employeeMetaInfo',
            'storage',
            'exitInterview',
        ]);
    }
}
