<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RosterStaffPerDay extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'roster_staff_per_days';

    protected $fillable = [
        'roster_day_id',
        'roster_employee_group_shift_id',
        'number_of_staff',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.roster_staff_per_days';
        parent::__construct($attributes);
    }

    public function rosterDay() {
        return $this->belongsTo(RosterDay::class, 'roster_day_id', 'id');
    }

    public function shift() {
        return $this->belongsTo(RosterEmployeeGroupShift::class, 'roster_employee_group_shift_id', 'id');
    }
}
