<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\Shift;

class RosterRescheduleRequestDate extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'roster_reschedule_request_dates';

    protected $fillable = [
        'request_id',
        'roster_day_id',
        'shift_id',
        'old_shift_id',
        'old_roster_day_id'
    ];

    protected $with = [
        'rosterDay',
        'oldRosterDay',
        'newShift',
        'oldShift',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.roster_reschedule_request_dates';
        parent::__construct($attributes);
    }

    public function reschedule_request() {
        return $this->belongsTo(RosterRescheduleRequest::class, 'request_id', 'id');
    }

    public function rosterDay() {
        return $this->belongsTo(RosterDay::class, 'roster_day_id', 'id');
    }

    public function oldRosterDay() {
        return $this->belongsTo(RosterDay::class, 'old_roster_day_id', 'id');
    }

    public function newShift() {
        return $this->belongsTo(Shift::class, 'shift_id', 'id');
    }

    public function oldShift() {
        return $this->belongsTo(Shift::class, 'old_shift_id', 'id');
    }
}
