<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\Shift;

class RosterRescheduleRequest extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'roster_reschedule_requests';

    protected $fillable = [
        'user_id',
        'requestee_id',
        'request_date',
        'new_shift_id',
        'old_shift_id',
        'reason',
        'status',
        'justification'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.roster_reschedule_requests';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function requestee() {
        return $this->belongsTo(User::class, 'requestee_id', 'id');
    }

    /**
     * Dependent tables
     */
    public function rosterDay() {
        return $this->belongsTo(RosterDay::class, 'request_date', 'id');
    }

    public function newShift() {
        return $this->belongsTo(Shift::class, 'new_shift_id', 'id');
    }

    public function oldShift() {
        return $this->belongsTo(Shift::class, 'old_shift_id', 'id');
    }

}
