<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RosterPartition extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'roster_id',
        'number_of_weeks',
        'start_date',
        'end_date',
    ];

    public function __construct(array $attributes = [])
    {
        $this->connection = 'adg_db';
        $this->table = env('ADG_DB_DATABASE') . '.roster_partitions';
        parent::__construct($attributes);
    }

    public function roster()
    {
        return $this->belongsTo(Roster::class, 'roster_id', 'id');
    }

    /**
     * Days - Dates records
     */
    public function days()
    {
        return $this->hasMany(RosterDay::class, 'roster_partition_id', 'id');
    }
}
