<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RosterHeadRequiredHours extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'roster_head_required_hours';

    protected $fillable = [
        'roster_partition_id',
        'roster_id',
        'required_hours'
    ];

    public function partition(){
        return $this->belongsTo(RosterPartition::class, 'roster_partition_id', 'id');
    }
    
    public function rosterHead() {
        return $this->belongsTo(Roster::class, 'roster_id','id');
    }
}
