<?php
namespace Suiterus\Adg\Models\Timekeeping\Roster;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\Shift;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterDayEmployeeShift;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterEmployeeGroup;

class RosterHeadEmployeeShift extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $connection = 'adg_db';
    
    protected $table = 'roster_head_employee_shifts';

    protected $fillable = [
        'roster_id',
        'roster_day_id',
        'shift_id',
        'roster_legend_id',
        'remarks'
    ];

    public function roster() {
        return $this->belongsTo(Roster::class, 'roster_id', 'id');
    }

    public function rosterDay() {
        return $this->belongsTo(RosterDay::class, 'roster_day_id', 'id');
    }

    public function shift() {
        return $this->belongsTo(Shift::class, 'shift_id', 'id');
    }
    public function legend() {
        return $this->belongsTo(RosterLegend::class, 'roster_legend_id', 'id');
    }

}
