<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterDayEmployeeShift;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterEmployeeGroup;

class RosterEmployeesPerGroup extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'roster_employees_per_groups';

    protected $fillable = [
        'user_id',
        'roster_employee_group_id',
        'required_work_hours',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.roster_employees_per_groups';
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function employeeGroup()
    {
        return $this->belongsTo(RosterEmployeeGroup::class, 'roster_employee_group_id', 'id');
    }

    public function dayEmployeeShifts()
    {
        return $this->hasMany(RosterDayEmployeeShift::class, 'roster_employees_per_group_id', 'id');
    }

    public function requiredHours()
    {
        return $this->hasMany(RosterEmployeeRequiredHours::class, 'roster_employee_id', 'id');
    }

    public function oldTransferRemarks()
    {
        return $this->hasMany(RosterTransferRemarks::class, 'old_employee_group_id', 'id');
    }
}
