<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\Shift;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterEmployeeGroup;

class RosterEmployeeGroupShift extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'roster_employee_group_shifts';

    protected $fillable = [
        'shift_id',
        'roster_employee_group_id',
    ];

    public function shift() {
        return $this->belongsTo(Shift::class,'shift_id','id');
    }

    public function rosterEmployeeGroup() {
        return $this->belongsTo(RosterEmployeeGroup::class, 'roster_employee_group_id','id');
    }
    public function staffPerShift() {
        return $this->hasMany(RosterStaffPerDay::class,'roster_employee_group_shift_id', 'id');
    }
}
