<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterEmployeesPerGroup;
use Suiterus\Adg\Models\SM\RosterGroup;
use Suiterus\Adg\Models\SM\Shift;

class RosterEmployeeGroup extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'roster_id',
        'group_id',
        'description'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.roster_employee_groups';
        parent::__construct($attributes);
    }

    public function roster()
    {
        return $this->belongsTo(Roster::class, 'roster_id', 'id');
    }
    public function rosterGroup()
    {
        return $this->belongsTo(RosterGroup::class, 'group_id', 'id');
    }

    public function employeeGroupShifts()
    {
        return $this->hasMany(RosterEmployeeGroupShift::class, 'roster_employee_group_id', 'id');
    }

    public function employees()
    {
        return $this->hasMany(RosterEmployeesPerGroup::class, 'roster_employee_group_id', 'id');
    }
}
