<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterEmployeesPerGroup;
use Suiterus\Adg\Models\Sm\Shift;

class RosterDayEmployeeShift extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'roster_day_employee_shifts';

    protected $fillable = [
        'roster_employees_per_group_id',
        'shift_id',
        'roster_day_id',
        'roster_legend_id',
        'remarks'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.roster_day_employee_shifts';
        parent::__construct($attributes);
    }

    public function rosterEmployeePerGroup() {
        return $this->belongsTo(RosterEmployeesPerGroup::class, 'roster_employees_per_group_id', 'id');
    }

    public function shift() {
        return $this->belongsTo(Shift::class, 'shift_id', 'id');
    }

    public function rosterDay() {
        return $this->belongsTo(RosterDay::class, 'roster_day_id', 'id');
    }

    public function rosterLegend() {
        return $this->belongsTo(RosterLegend::class, 'roster_legend_id', 'id');
    }
}
