<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\Shift;

class RosterDay extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'roster_partition_id',
        'date',
        'day'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.roster_days';
        parent::__construct($attributes);
    }


    public function rosterPartition()
    {
        return $this->belongsTo(RosterPartition::class, 'roster_partition_id', 'id');
    }

    /**
     * Dependent tables
     */
    public function employeeShifts()
    {
        return $this->hasMany(RosterDayEmployeeShift::class, 'roster_day_id', 'id');
    }

    public function staffPerDays()
    {
        return $this->hasMany(RosterStaffPerDay::class, 'roster_day_id', 'id');
    }

    public function rosterReschedule()
    {
        return $this->hasOne(RosterRescheduleRequest::class, 'roster_day_id', 'id');
    }
}
