<?php

namespace Suiterus\Adg\Models\Timekeeping\Roster;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Unit;

class Roster extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'rosters';

    protected $fillable = [
        'office_id',
        'department_id',
        'division_id',
        'section_id',
        'unit_id',
        'head_nurse_id',
        'title',
        'description',
        'number_of_weeks',
        'start_date',
        'end_date',
        'partition',
        'status',
        'created_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.rosters';
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }

    public function office() {
        return $this->belongsTo(Office::class, 'office_id', 'id');
    }

    public function department() {
        return $this->belongsTo(Department::class, 'department_id', 'id');
    }

    public function division() {
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

    public function section() {
        return $this->belongsTo(Section::class, 'section_id', 'id');
    }

    public function unit() {
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }

    public function headNurse() {
        return $this->belongsTo(User::class, 'head_nurse_id', 'id');
    }

    /**
     * Dependent tables
     */
    public function partitions() {
        return $this->hasMany(RosterPartition::class, 'roster_id', 'id');
    }

    public function employeeGroups() {
        return $this->hasMany(RosterEmployeeGroup::class, 'roster_id', 'id');
    }

    public function headEmployeeShifts() {
        return $this->hasMany(RosterHeadEmployeeShift::class, 'roster_id' , 'id');
    }
    
    public function headRequiredHours() {
        return $this->hasMany(RosterHeadRequiredHours::class, 'roster_id','id');
    }

}
