<?php

namespace Suiterus\Adg\Models\Timekeeping;

use Suiterus\Adg\Models\Timekeeping\BiometricRfidUser;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RFID extends Model
{
   
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
    protected $table = 'rfid';

    protected $fillable = [
        "biometric_rfid_id",
        "rfid",
        "card_number",
        "status",
        "date_issued",
        "created_by",
        "updated_by"
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.rfid';
        parent::__construct($attributes);
    }

    public function device_record() {
        return $this->belongsTo(BiometricRfidUser::class, 'biometric_rfid_id', 'id');
    }
}
