<?php

namespace Suiterus\Adg\Models\Timekeeping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fingerprint extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'fingerprints';

    protected $fillable = [
        'biometric_id',
        'finger_number',
        'fingerprint_template',
    ];

    protected $appends = [
        'date_synced'
    ];

    public function biometric() {
        return $this->belongsTo(Biometrics::class, 'biometric_id', 'id');
    }

    public function getDateSyncedAttribute() {
        return date('F d, Y - h:i A', strtotime($this->updated_at));
    }
}
