<?php

namespace Suiterus\Adg\Models\Timekeeping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeScheduleHours extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $fillable = [
        'employee_has_schedule_id',
        'hours',
        'created_by',
        'updated_by'
    ];

    public function employeeSchedule() {
        return $this->belongsTo('Suiterus\Adg\Models\Timekeeping\EmployeeSchedule', 'employee_has_schedule_id', 'id');
    }
}
