<?php

namespace Suiterus\Adg\Models\Timekeeping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeSchedule extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
   
    protected $table = "employee_schedules";
   
    protected $fillable = [
        'user_id',
        'schedule_template_id',
        'created_by',
        'updated_by',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $with = ['user','schedule_template', 'hours'];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.employee_schedules';
        parent::__construct($attributes);
    }

    public function schedule_template()
    {
        return $this->belongsTo('Suiterus\Adg\Models\SM\ScheduleTitle', 'schedule_template_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id', 'id');
    }

    public function hours() {
        return $this->hasOne('Suiterus\Adg\Models\Timekeeping\EmployeeScheduleHours', 'employee_has_schedule_id', 'id');
    }
}
