<?php

namespace Suiterus\Adg\Models\Timekeeping;

use Suiterus\Adg\Models\Timekeeping\BiometricRfidUser;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Biometrics extends Model
{
    use HasFactory, softDeletes;
    protected $connection ='adg_db';

    protected $table ='biometrics';

    protected $fillable = [
      "biometric_rfid_id",
      "type",
      "biometric_number",
      "status",
      "date_issued",
      "created_by",
      "updated_by",
        
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.biometrics';
        parent::__construct($attributes);
    }

    public function device_record() {
      return $this->belongsTo(BiometricRfidUser::class, 'biometric_rfid_id', 'id');
    }

    public function fingerprints() {
      return $this->hasMany(Fingerprint::class, 'biometric_id', 'id');
    }

    public function getDateIssuedAttribute($date) {
      return date('F d, Y', strtotime($date));
    }

}
