<?php

namespace Suiterus\Adg\Models\Timekeeping;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Timekeeping\Biometrics;
use Suiterus\Adg\Models\Timekeeping\RFID;
use App\Models\User;

class BiometricRfidUser extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'biometric_rfid_users';

    protected $fillable = [
        'user_id',
        'device_user_id',
        'unique_id'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.biometric_rfid_users';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function biometrics() {
        return $this->hasOne(Biometrics::class, 'biometric_rfid_id', 'id');
    }

    public function card() {
        return $this->hasOne(RFID::class, 'biometric_rfid_id', 'id');
    }
}
