<?php

namespace Suiterus\Adg\Models\Timekeeping;

use App\Enums\AttendanceLegend as EnumsAttendanceLegend;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AttendanceLegend extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'attendance_legends';

    public $timestamps = false;

    protected $fillable = [
        'attendance_id',
        'legend'
    ];

    public static function boot() {
        parent::boot();
        static::created(function($record) {
            $record->created_at = now();
            $record->save();
        });
    }

    public function attendance() {
        return $this->belongsTo(Attendance::class, 'attendance_id', 'id');
    }

    /**
     * Function to set attendance as late
     */
    public function setLate($attendance) {
        $attendance->legends()->create([
           'legend' => EnumsAttendanceLegend::LATE 
        ]);
    }

    /**
     * Set attendance as undertime
     */
    public function setUndertime($attendance) {
        $attendance->legends()->create([
           'legend' => EnumsAttendanceLegend::UNDERTIME 
        ]);
    }

    /**
     * Set attendance as overtime
     */
    public function setOvertime($attendance) {
        $attendance->legends()->create([
            'legend' => EnumsAttendanceLegend::OVERTIME
        ]);
    }    

}
