<?php

namespace Suiterus\Adg\Models\Supplemental;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Promotion\PromotionApplication;
use Suiterus\Hrjp\Models\SupplementalDetails;

class SupplementalDetailUser extends Model
{
    use HasFactory, softDeletes;

    protected $connection = 'adg_db';

    protected $table = 'supplemental_detail_users';

    protected $fillable = [
        'application_id',
        'supplemental_detail_id',
        'attachment',
        'status',
        'justification',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    protected $with = [
        'supplementalDetail'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.supplemental_detail_users';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function promotionApplication()
    {
        return $this->belongsTo(PromotionApplication::class, 'application_id', 'id');
    }

    public function supplementalDetail()
    {
        return $this->belongsTo(SupplementalDetails::class, 'supplemental_detail_id', 'id');
    }

}
