<?php

namespace Suiterus\Adg\Models\Supplemental;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Promotion\PromotionApplication;
use Suiterus\Hrjp\Models\CompletionAccomplishment;

class SupplementalCompletionUser extends Model
{
    use HasFactory, softDeletes;

    protected $connection = 'adg_db';

    protected $table = 'supplemental_completion_users';

    protected $fillable = [
        'application_id',
        'supplemental_completion_id',
        'attachment',
        'status',
        'justification',
        'created_by',
        'created_at',
        'updated_by',
        'updated_at',
        'deleted_at'
    ];

    protected $with = [
        'supplementalCompletion'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.supplemental_completion_users';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function promotionApplication()
    {
        return $this->belongsTo(PromotionApplication::class, 'application_id', 'id');
    }

    public function supplementalCompletion()
    {
        return $this->belongsTo(CompletionAccomplishment::class, 'supplemental_completion_id', 'id');
    }

}
