<?php

namespace App\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Hrjp\Models\Position_history;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\SuccessionManagement\CriticalPosition;

class Successor extends Model
{
    use HasFactory;

    protected $fillable = [
        'critical_position_id',
        'successor_id',
        'status'
    ];

    protected $appends = [
        'number_of_promotion'
    ];

    protected $with = [
        'successor'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.successors';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function criticalPosition(){
        return $this->belongsTo(CriticalPosition::class, 'critical_position_id', 'id');
    }

    public function successor(){
        return $this->belongsTo(User::class, 'successor_id', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ])->with(['latest_evaluation']);
    }

    public function successorPromotions(){
        return $this->hasMany(Position_history::class, 'user_id', 'successor_id')->where('status', 1);
    }

    public function getNumberOfPromotionAttribute(){
        return Position_history::where([
            'user_id' => $this->successor_id,
            'status' => 1
        ])->count();
    }
}
