<?php

namespace Suiterus\Adg\Models\SuccessionManagement;

use App\Models\User;
use App\Models\Successor;
use Suiterus\Adg\Models\SM\Remark;
use Suiterus\Hrjp\Models\ItemCode;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CriticalPosition extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'item_code_id',
        'current_incumbent_id',
        'reason_for_replacement_id',
        'vacancy_start',
        'status',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $with = [
        'itemCode',
        'currentIncumbent',
        'reasonForReplacement',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.critical_positions';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function reasonForReplacement(){
        return $this->belongsTo(Remark::class, 'reason_for_replacement_id', 'id');
    }

    public function itemCode(){
        return $this->belongsTo(ItemCode::class, 'item_code_id');
    }

    public function currentIncumbent(){
        return $this->belongsTo(User::class, 'current_incumbent_id', 'id')->without([
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function firstThreeSuccessors(){
        return $this->hasMany(Successor::class, 'critical_position_id', 'id')->take(3);
    }

    public function successors(){
        return $this->hasMany(Successor::class, 'critical_position_id', 'id');
    }
}
