<?php

namespace Suiterus\Adg\Models\ServiceRecord;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\EmployeeType;
use Suiterus\Adg\Models\SM\Remark;
use Suiterus\Hrjp\Models\Position;

class ServiceRecord extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $fillable = [
        'user_id',
        'start_date',
        'end_date',
        'position_id',
        'salary',
        'allowance',
        'employee_type_id',
        'division_id',
        'remark_id',
        'created_by',
        'updated_by'
    ];

    protected $appends = [
        'formatted_start_date',
        'formatted_end_date'
    ];

    protected $with = [
        'position',
        'employeeType',
        'division',
        'remark'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.service_records';
        parent::__construct($attributes);
    }

    public function getSalaryAttribute($salary) {
        return number_format($salary);
    }

    public function getAllowanceAttribute($allowance) {
        return number_format($allowance);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function position(){
        return $this->belongsTo(Position::class, 'position_id', 'id');
    }

    public function employeeType(){
        return $this->belongsTo(EmployeeType::class, 'employee_type_id', 'id');
    }

    public function division(){
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

    public function remark(){
        return $this->belongsTo(Remark::class, 'remark_id', 'id');
    }

    public function getFormattedStartDateAttribute(){
        return date("m/d/Y", strtotime($this->start_date));
    }

    public function getFormattedEndDateAttribute(){
        return date("m/d/Y", strtotime($this->end_date));
    }
    
}
