<?php

namespace Suiterus\Adg\Models\Salary;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Salary\PublicSalary;
use Suiterus\Adg\Models\Salary\PrivateSalary;

use App\Models\User;

class UserSalary extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'user_salaries';

    protected $fillable = [
        'user_id',
        'account_number',
        'appointment_date',
        'date_of_effectivity',
        'status',
        'official_business_pay',
        'e_cola',
        'special_pay',
        'load_allowance',
        'transportation_allowance',
        'branch_allowance',
        'gate_allowance',
        'rice_allowance',
        'substinence_allowance',
        'laundry_allowance',
        'withholding_tax_option',
        'remarks',
        'created_by',
        'updated_by'
    ];

    protected $with = [
        'user'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE').'.user_salaries';
        parent::__construct($attributes);
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function publicSalary(){
        return $this->hasOne(PublicSalary::class, 'user_salary_id', 'id');
    }

    public function privateSalary(){
        return $this->hasOne(PrivateSalary::class, 'user_salary_id', 'id');
    }

}
