<?php

namespace Suiterus\Adg\Models\Salary;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\SalaryGrade;
use Suiterus\Adg\Models\Salary\UserSalary;
class PublicSalary extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'public_salaries';

    protected $fillable = [
        'user_salary_id',
        'salary_grade_id'
    ];

    protected $with = [
        'salaryGrade'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE').'.public_salaries';
        parent::__construct($attributes);
    }

    public function salaryGrade(){
        return $this->belongsTo(SalaryGrade::class, 'salary_grade_id', 'id');
    }

    public function userSalary(){
        return $this->belongsTo(UserSalary::class, 'user_salary_id', 'id');
    }
}
