<?php

namespace Suiterus\Adg\Models\Salary;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Salary\UserSalary;

class PrivateSalary extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_salary_id',
        'salary',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE').'.private_salaries';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function userSalary(){
        return $this->belongsTo(UserSalary::class, 'user_salary_id', 'id');
    }
}
