<?php

namespace Suiterus\Adg\Models\Salary;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Payroll\SpecialPay;

class EmployeeSpecialPay extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'employee_special_pays';

    protected $fillable = [
        'user_id',
        'special_pay_id',
        'amount',
        'created_by',
        'updated_by'
    ];

    protected $with = [
        'user'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.employee_special_pays';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function special_pay() {
        return $this->belongsTo(SpecialPay::class, 'special_pay_id', 'id');
    }
}
