<?php

namespace Suiterus\Adg\Models\Salary;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Payroll\Allowance;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmployeeAllowance extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'employee_allowances';

    protected $fillable = [
        'user_id',
        'allowance_id',
        'amount',
        'effectivity_date',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.employee_allowances';
        parent::__construct($attributes);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function allowance() {
        return $this->belongsTo(Allowance::class, 'allowance_id');
    }
}
