<?php

namespace Suiterus\Adg\Models\SPMS;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserPcrForm extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'pcr_form_id',
        'created_by',
        'updated_by',
    ];

    protected $with = ['pcrForm'];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.user_pcr_forms';
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function pcrForm(){
        return $this->belongsTo(PCRFormType::class, 'pcr_form_id');
    }
}
