<?php

namespace Suiterus\Adg\Models\SPMS;

use App\Models\User;
use Suiterus\Adg\Models\SPMS\Mfo;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserMfo extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'mfo_id',
        'created_by',
    ];

    protected $with = [
        'mfo'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.user_mfos';
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function mfo()
    {
        return $this->belongsTo(Mfo::class, 'mfo_id', 'id');
    }
}
