<?php

namespace Suiterus\Adg\Models\SPMS;

use Suiterus\Adg\Models\SM\Office;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PerformanceRatingReport extends Model
{
    use HasFactory;

    protected $fillable = [
        'office_id',
        'department_id',
        'division_id',
        'section_id',
        'unit_id',
        'rating_numeric',
        'rating_adjective',
        'file_path',
        'start_date',
        'end_date',
        'created_by'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.performance_rating_reports';
        parent::__construct($attributes);
    }

    public function office()
    {
        return $this->belongsTo(Office::class, 'office_id', 'id');
    }
}
